/*
 * Decompiled with CFR 0.152.
 */
package org.molap.db.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.molap.db.jdbc.JDBCDatabaseDriver;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u000b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J:\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0018\u00010\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00052\b\u0010\u0011\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016J\b\u0010\u0012\u001a\u00020\u0005H\u0016J0\u0010\u0013\u001a\u00020\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u00052\b\u0010\u000e\u001a\u0004\u0018\u00010\u0005H\u0016R\u0014\u0010\u0004\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/molap/db/jdbc/SQLServerDatabaseDriver;", "Lorg/molap/db/jdbc/JDBCDatabaseDriver;", "<init>", "()V", "className", "", "getClassName", "()Ljava/lang/String;", "prefix", "getPrefix", "getDatabases", "", "host", "username", "password", "getTables", "url", "database", "toString", "getURL", "schema", "Companion", "molap-jdbc"})
public final class SQLServerDatabaseDriver
extends JDBCDatabaseDriver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String className = "com.microsoft.sqlserver.jdbc.SQLServerDriver";

    @Override
    @NotNull
    protected String getClassName() {
        return className;
    }

    @Override
    @NotNull
    protected String getPrefix() {
        return "sqlserver";
    }

    @Override
    @NotNull
    public Iterable<String> getDatabases(@Nullable String host, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = this.getConnection(this.getURL(host, null, username, password), username, password);
        List databases = new ArrayList();
        Connection connection = conn;
        Intrinsics.checkNotNull((Object)connection);
        ResultSet schemas = connection.getMetaData().getCatalogs();
        while (schemas.next()) {
            String string = schemas.getString(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            databases.add(string);
        }
        return databases;
    }

    @Override
    @Nullable
    public Iterable<String> getTables(@Nullable String url, @Nullable String database, @Nullable String username, @Nullable String password) throws SQLException {
        Connection conn = this.getConnection(url, username, password);
        List tables = new ArrayList();
        Connection connection = conn;
        Intrinsics.checkNotNull((Object)connection);
        DatabaseMetaData meta = connection.getMetaData();
        String[] stringArray = new String[]{"TABLE"};
        ResultSet result = meta.getTables(null, null, "%", stringArray);
        while (result.next()) {
            Object tableName = result.getString("TABLE_NAME");
            String schemaName = result.getString("TABLE_SCHEM");
            if (schemaName != null) {
                tableName = schemaName + "." + (String)tableName;
            }
            tables.add(tableName);
        }
        return tables;
    }

    @NotNull
    public String toString() {
        return "Microsoft SQL Server";
    }

    @Override
    @NotNull
    public String getURL(@Nullable String host, @Nullable String schema, @Nullable String username, @Nullable String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "//" + host;
        }
        url = url + ";";
        if (schema != null) {
            url = url + "databaseName=" + schema + ";";
        }
        if (username == null || Intrinsics.areEqual((Object)username, (Object)"")) {
            url = url + "integratedSecurity=true;";
        }
        return url;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/molap/db/jdbc/SQLServerDatabaseDriver$Companion;", "", "<init>", "()V", "className", "", "exist", "", "molap-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean exist() {
            return JDBCDatabaseDriver.exist(SQLServerDatabaseDriver.className);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

