/*
 * Copyright (c) 2009 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

import java.sql.Connection
import java.sql.SQLException

class DerbyDatabaseDriver : JDBCDatabaseDriver() {
    override fun getURL(host: String?, schema: String?, username: String?, password: String?): String {
        var url = "jdbc:$prefix:"
        if (schema != null) {
            url += schema
            url += ";create=true"
        }
        return url
    }

    @Throws(SQLException::class)
    override fun dropTable(connection: Connection, table: String) {
        super.dropTable(connection, table.toUpperCase())
    }

    override val className: String
        get() = Companion.className
    override val prefix: String
        get() = "derby"

    override fun toString(): String {
        return "Derby"
    }

    companion object {
        private const val className = "org.apache.derby.jdbc.EmbeddedDriver"
        fun exist(): Boolean {
            return JDBCDatabaseDriver.Companion.exist(className)
        }
    }
}