/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

import java.sql.DriverManager
import java.sql.SQLException
import java.util.ArrayList

class OracleDatabaseDriver : JDBCDatabaseDriver() {
    override val className: String
        get() = Companion.className

    override fun getURL(host: String?, schema: String?, username: String?, password: String?): String {
        var url = "jdbc:$prefix:"
        if (host != null) {
            url += "@$host"
        }
        //        if (schema != null) {
//            url += "/" + schema;
//        }
        return url
    }

    override fun getQuery(query: String): String {
        return query
    }

    override val prefix: String
        get() = "oracle:thin"

    @Throws(SQLException::class)
    override fun getDatabases(host: String?, username: String?, password: String?): Iterable<String> {
        val url = getURL(host, null, username, password)
        val conn = DriverManager.getConnection(url, username, password)
        val databases: MutableList<String> = ArrayList()
        val schemas = conn.metaData.schemas
        while (schemas.next()) {
            databases.add(schemas.getString(1))
        }
        return databases
    }

    @Throws(SQLException::class)
    override fun getTables(url: String?, database: String?, username: String?, password: String?): Iterable<String?>? {
        val conn = DriverManager.getConnection(url, username, password)
        val tables: MutableList<String?> = ArrayList()
        val meta = conn.metaData
        val result = meta.getTables(null, null, null, arrayOf("TABLE", "VIEW"))
        while (result.next()) {
            val schema = result.getString("TABLE_SCHEM")
            if (database == null || database.equals(schema, ignoreCase = true)) {
                tables.add(result.getString("TABLE_NAME"))
            }
        }
        return tables
    }

    override fun toString(): String {
        return "Oracle"
    }

    companion object {
        private const val className = "oracle.jdbc.driver.OracleDriver"
        fun exist(): Boolean {
            return JDBCDatabaseDriver.Companion.exist(className)
        }
    }
}