/*
 * Copyright (c) 2009 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.db.jdbc

import java.sql.DriverManager
import java.sql.SQLException
import java.util.ArrayList

open class PostgreSQLDatabaseDriver : JDBCDatabaseDriver() {
    override val className: String
        get() = Companion.className
    override val prefix: String
        get() = "postgresql"

    override fun toString(): String {
        return "PostgreSQL"
    }

    @Throws(SQLException::class)
    override fun getDatabases(host: String?, username: String?, password: String?): Iterable<String> {
        val conn = DriverManager.getConnection(getURL(host, "postgres", username, password), username, password)
        val databases: MutableList<String> = ArrayList()
        val query = "select datname from pg_catalog.pg_database where not datistemplate"
        val pst = conn.prepareStatement(query)
        val schemas = pst.executeQuery()
        while (schemas.next()) {
            databases.add(schemas.getString(1))
        }
        return databases
    }

    override fun generateParseDate(date: String): String {
        return "to_date('$date', 'YYYY-MM-DD')"
    }

    companion object {
        private const val className = "org.postgresql.Driver"
        fun exist(): Boolean {
            return JDBCDatabaseDriver.Companion.exist(className)
        }
    }
}