/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class CountAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = Long::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val distributiveStatistics = cuboid!!.getDistributiveStatistics(group, column, null)
        return distributiveStatistics?.count
    }

    override fun toString(): String {
        return "Count(" + column.name + ")"
    }
}