/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.reflect.KClass

class MedianAggregation(private val column: Series<Any?, Any?>) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = Number::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val univariateStatistics = cuboid!!.getUnivariateStatistics(group, column)
        return univariateStatistics?.median
    }

    override fun toString(): String {
        return "Median(" + column.name + ")"
    }
}