/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

import com.macrofocus.common.collection.arraycopy

class Dice(vararg path: Set<Any?>?) {
    val path: Array<out Set<Any?>?> = path
    fun drillDown(vararg columns: Set<Any?>): Dice {
        val path: Array<Set<Any?>?> = arrayOfNulls<Set<Any?>>(path.size + columns.size)
        arraycopy(this.path, 0, path, 0, this.path.size)
        arraycopy(columns, 0, path, this.path.size, columns.size)
        return create(*path.requireNoNulls())
    }

    fun drillDownByArray(columns: Array<Set<Any?>?>): Dice {
        val path: Array<Set<Any?>?> = arrayOfNulls<Set<Any?>>(path.size + columns.size)
        arraycopy(this.path, 0, path, 0, this.path.size)
        arraycopy(columns, 0, path, this.path.size, columns.size)
        return createByArray(path)
    }

    fun drillUp(): Dice? {
//        assert(path.size > 0) { this }
        return if (path.size > 0) {
            val path: Array<Set<Any?>?> = arrayOfNulls<Set<Any?>>(path.size - 1)
            arraycopy(this.path, 0, path, 0, path.size)
            create(*path as Array<out Set<Any?>>)
        } else {
            null
        }
    }

    val last: Set<Any?>?
        get() = path[path.size - 1]

    fun changeLast(valuesSets: Set<Any?>): Dice {
        return drillUp()!!.drillDown(valuesSets)
    }

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o !is Dice) return false

        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return path.contentEquals(o.path)
    }

    override fun hashCode(): Int {
        return path.contentHashCode()
    }

    override fun toString(): String {
        return "Dice{" +
                "path=" + path.contentToString() +
                '}'
    }

    companion object {
        private operator fun get(vararg path: Set<Any?>?): Dice {
            return Dice(*path)
        }

        fun create(vararg path: Set<Any?>): Dice {
            return get(*path)
        }

        fun createByArray(path: Array<Set<Any?>?>): Dice {
            return get(*path)
        }
    }
}