/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

object GroupFactory {
    fun createRoot(): Group {
        return if (false) {
            ArrayGroup.get()
        } else {
            LinkedGroup()
        }
    }

    fun create(vararg path: Any?): Group {
        return if (false) {
            ArrayGroup.get(path)
        } else {
            create(createRoot(), *path)
        }
    }

    fun create(root: Group, vararg path: Any?): Group {
        var current: Group = root
        for (o in path) {
            current = current.drillDown(o)
        }
        return current
    }
}