/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

import com.macrofocus.common.annotation.Synchronized

class LinkedGroup : Group {
    override val pathLength: Int
    private val parent: LinkedGroup?
    override val last: Any?
    private var children: MutableMap<Any, LinkedGroup>? = null

    constructor() {
        pathLength = 0
        parent = null
        last = null
    }

    constructor(parent: LinkedGroup?, value: Any?) {
//        assert(parent != null)
        this.parent = parent
        last = value
        pathLength = parent!!.pathLength + 1
    }

    override fun drillUp(): Group? {
        return parent
    }

    @Synchronized
    override fun drillDown(valueAt: Any?): Group {
        val child: Group?
        if (children == null) {
            children = HashMap<Any, LinkedGroup>()
            child = null
        } else {
            child = children!![valueAt]
        }
        return if (child == null) {
            val group = LinkedGroup(this, valueAt)
            children!![valueAt!!] = group
            group
        } else {
            child
        }
    }

    override fun getPath(level: Int): Any? {
        var current: LinkedGroup? = this
        for (i in pathLength - 1 downTo level + 1) {
            current = current!!.parent
        }
        return current!!.last
    }

    override val path: Array<Any?>
        get() {
            val path = arrayOfNulls<Any>(pathLength)
            var current: LinkedGroup? = this
            for (i in pathLength - 1 downTo 0) {
                path[i] = current!!.last
                current = current.parent
            }
            return path
        }

    override fun startsWith(group: Group?): Boolean {
        if (this === group) return true
        if (group == null) return false
        val thisPath = path
        val length = thisPath.size
        val otherPath: Array<out Any?> = group.path!!
        if (otherPath.size >= length) return false
        for (i in otherPath.indices) {
            val o1 = thisPath[i]
            val o2 = otherPath[i]
            if (!(if (o1 == null) o2 == null else o1 == o2)) return false
        }
        return true
    }

    //    @Override
    //    public boolean equals(Object o) {
    //        if (this == o) return true;
    //        if (!(o instanceof Group)) return false;
    //
    //        Group path1 = (Group) o;
    //
    //        return Arrays.equals(getPath(), path1.getPath());
    //    }
    //
    //    @Override
    //    public int hashCode() {
    //        return Arrays.hashCode(getPath());
    //    }
    override fun toString(): String {
        return "LinkedGroup{" +
                "path=" + path.contentToString() +
                '}'
    }
}