/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.query

import com.macrofocus.common.collection.UniversalComparator
import org.molap.aggregates.aggregation.Aggregation
import org.molap.aggregates.cube.Dimensions
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import kotlin.math.min

class OrderQuery(query: Query, aggregations: Array<Aggregation<Any?>>) : AbstractQuery() {
    private val query: Query
    override val aggregations: Array<Aggregation<Any?>>
    get() {
        return query.aggregations
    }
    override var groups: List<Group>? = null
    get() {
        if (isDirty) {
            run()
        }
        return field
    }
    private val universalComparator: Comparator<Any?> = UniversalComparator()
    val queryListener: QueryListener = object : QueryListener {
        override fun queryChanged() {
            isDirty = true
            notifyQueryChanged()
        }
    }

    private fun run() {
        isDirty = false
        val groups: MutableList<Group> = ArrayList<Group>()
        for (group in query.groups!!) {
            groups.add(group as Group)
        }
        groups.sortWith(object : Comparator<Group> {
            override fun compare(a: Group, b: Group): Int {
                return compare(query, a, b)
            }

            fun compare(query: Query, o1: Group, o2: Group): Int {
                val length: Int = min(o1.pathLength, o2.pathLength)
                if (length > 1 && o1.drillUp() !== o2.drillUp()) {
                    val c = compare(query.drillUp(), o1.drillUp()!!, o2.drillUp()!!)
                    if (c != 0) {
                        return c
                    }
                }
                for (aggregation in aggregations) {
                    val v1: Any? = query.getValue(o1, aggregation)
                    val v2: Any? = query.getValue(o2, aggregation)
                    val compare: Int = universalComparator.compare(v1, v2)
                    if (compare != 0) {
                        return compare
                    }
                }
                val x: Int = o1.pathLength
                val y: Int = o2.pathLength
                return if (x < y) -1 else if (x == y) 0 else 1
            }
        })
        this.groups = groups
    }

    override fun getValue(path: Group?, aggregation: Aggregation<Any?>): Any? {
        return query.getValue(path, aggregation)
    }

    override val dimensions: Dimensions?
        get() = query.dimensions

    override val cuboid: Cuboid?
        get() = query.cuboid

    override fun setDice(valuesSets: Set<Any?>) {
        query.setDice(valuesSets)
    }

    init {
        this.query = query
//        this.aggregations = aggregations
        query.addWeakQueryListener(queryListener)
    }
}