/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

/**
 * Created by luc on 24/05/16.
 */
class BasicAutoConverter : AutoConverter {
    override fun convert(
        input: TypeConverter.Input,
        output: TypeConverter.Output
    ): Boolean {
        var fireEvent = false

        val toCommonTypeConverter: ToCommonTypeConverter = ToCommonTypeConverter()
        val toDoubleTypeConverter: ToDoubleTypeConverter = ToDoubleTypeConverter()
        val toIntegerTypeConverter: ToIntegerTypeConverter =
            ToIntegerTypeConverter()
        val toDateTypeConverter : ToDateTypeConverter = ToDateTypeConverter();
        val toBooleanTypeConverter: ToBooleanTypeConverter =
            ToBooleanTypeConverter()

        //        ToURLTypeConverter toURLTypeConverter = new ToURLTypeConverter();
        val toGeometryTypeConverter : ToGeometryTypeConverter = ToGeometryTypeConverter();
//        ToByteArrayTypeConverter toByteArrayTypeConverter = new ToByteArrayTypeConverter();
//        ToColorTypeConverter toColorTypeConverter = new ToColorTypeConverter();

        // ToDo but check VVL with Punktlich
        if (toCommonTypeConverter.isConvertable(input)) {
            output.setType(toCommonTypeConverter.common)
            fireEvent = true
        } else {
            output.setType(input.getType())
        }

        if (toDoubleTypeConverter.isConvertable(input)) {
            if (toIntegerTypeConverter.isConvertable(input)) {
                output.setType(toIntegerTypeConverter.convert(input, output))
            } else {
                output.setType(toDoubleTypeConverter.convert(input, output))
            }
            fireEvent = true
        } else {
            if (toBooleanTypeConverter.isConvertable(input)) {
                output.setType(toBooleanTypeConverter.convert(input, output))
                fireEvent = true
            } else {
                if (toDateTypeConverter.isConvertable(input)) {
                    output.setType(toDateTypeConverter.convert(input, output));
                    fireEvent = true;
//                } else if (toURLTypeConverter.isConvertable(input)) {
//                    output.setType(toURLTypeConverter.convert(input, output));
//                    fireEvent = true;
                } else if (toGeometryTypeConverter.isConvertable(input)) {
                    output.setType(toGeometryTypeConverter.convert(input, output));
                    fireEvent = true;
//                } else if (toByteArrayTypeConverter.isConvertable(input)) {
//                    output.setType(toByteArrayTypeConverter.convert(input, output));
//                    fireEvent = true;
//                } else if (toColorTypeConverter.isConvertable(input)) {
//                    output.setType(toColorTypeConverter.convert(input, output));
//                    fireEvent = true;
                }
            }
        }
        return fireEvent
    }
}
