/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

import kotlin.reflect.KClass

class ToCommonTypeConverter : TypeConverter {
    var common: KClass<*> = Any::class

    override fun isConvertable(input: TypeConverter.Input): Boolean {
        var allNull = true
        common = Any::class
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (common == Any::class) {
                    common = v::class
                    allNull = false
                } else {
                    if (common != v::class) {
                        common = Any::class
                        break
                    }
                }
            }
        }

        if (!allNull && common != null && common != input.getType() && common != Any::class) {
            return true
        } else {
            common = input.getType()
            return false
        }
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*>? {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            output.set(row, v)
        }

        return common
    }

    override val type: KClass<*>
        get() = common
}
