/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

import kotlin.reflect.KClass

class ToIntegerTypeConverter : org.molap.convert.TypeConverter {
    override fun isConvertable(input: TypeConverter.Input): Boolean {
        if (input.getType() !== Int::class) {
            var allNull = true
            for (row in 0..<input.size()) {
                val v: Any? = input.get(row)
                if (v != null) {
                    if (v is String) {
                        val s = v.trim { it <= ' ' }
                        if (s != "") {
                            allNull = false
                            try {
                                s.toInt()
                            } catch (e: NumberFormatException) {
                                return false
                            }
                        }
                    } else if (v !is Int) {
                        return false
                    }
                }
            }
            return !allNull
        } else {
            return false
        }
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        try {
                            output.set(row, s.toInt())
                        } catch (e: NumberFormatException) {
                            output.set(row, null)
                        }
                    } else {
                        output.set(row, null)
                    }
                } else if (v !is Int) {
                    output.set(row, null)
                }
            }
        }
        return Int::class
    }


    override val type: KClass<*>
        get() = Int::class
}
