package org.molap.dataframe

import com.macrofocus.common.math.isInfinite
import com.macrofocus.common.math.isNaN
import org.molap.series.Series

object DataFrameHelper {
    @Deprecated("")
    fun <R, C> getColumnStatistics(dataFrame: DataFrame<R, C, Any?>, column: C): ColumnStatistics {
        var min: Number? = null
        var max: Number? = null
        var sum = 0.0
        var count: Long = 0
        val series: Series<R, out Any?> = dataFrame.getColumn(column)!!
        for (row in dataFrame.rows()) {
            val value: Any? = series.get(row)
            if (value != null) {
                if (value is Number) {
                    val number = value
                    val d = number.toDouble()
                    if (number is Double) {
                        if (!isNaN(d) && !isInfinite(d)) {
                            if (min == null || d < min.toDouble()) {
                                min = number
                            }
                            if (max == null || d > max.toDouble()) {
                                max = number
                            }
                            sum += number.toDouble()
                            count++
                        }
                    } else if (number is Float) {
                        val f = number.toFloat()
                        if (!isNaN(f) && !isInfinite(f)) {
                            if (min == null || d < min.toDouble()) {
                                min = number
                            }
                            if (max == null || d > max.toDouble()) {
                                max = number
                            }
                        }
                    } else {
                        if (min == null || d < min.toDouble()) {
                            min = number
                        }
                        if (max == null || d > max.toDouble()) {
                            max = number
                        }
                        sum += d
                        count++
                    }
                    // Todo: reimplement
//                } else if (value is java.util.Date) {
//                    val date: java.util.Date = value as java.util.Date
//                    val time: Long = date.getTime()
//                    if (min == null || time < min.toDouble()) {
//                        min = time
//                    }
//                    if (max == null || time > max.toDouble()) {
//                        max = time
//                    }
//                    sum += time.toDouble()
//                    count++
                }
            }
        }
        return ColumnStatistics(min, max, sum, count)
    }
}
