package org.molap.dataframe

class ListDataFrameBuilder<R,C>(
    private val rows: List<R>
) {
    val columns = mutableMapOf<C, Column<R, Any?>>()

    inline fun <reified V> column(name: C, noinline values: (R) -> V) {
        // Optional: make column() return Column<R, Any?> should this cast ever become a problem
        columns[name] = column<R,V>(values)
    }

    inline infix fun <reified V> C.to(noinline values: R.() -> V) {
        // Optional: make column() return Column<R, Any?> should this cast ever become a problem
        columns[this] = column<R,V>(values)
    }

    fun build(): ListDataFrame<R, C, Any?> {
        return ListDataFrame(rows, columns)
    }
}