package org.molap.datetime

import kotlinx.datetime.*
import kotlinx.datetime.format.*

data class DateTimeTz(val datetime: Instant, val offset: TimeZone) : Comparable<DateTimeTz> {
    fun toISOBasicString() : String {
        return datetime.format(isoBasicFormat, offset = offset.offsetAt(datetime)) // .replace(":", "")
    }

    fun toISOString() : String {
        return datetime.format(isoFormat, offset = offset.offsetAt(datetime))
    }

    fun toUTCString() : String {
        return datetime.toString()
    }

    override fun compareTo(other: DateTimeTz): Int {
        return this.datetime.compareTo(other.datetime)
    }

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DateTimeTz

        return datetime == other.datetime
    }

    override fun hashCode(): Int {
        return datetime.hashCode()
    }

    companion object {
        internal val ISO_TIME_BASIC by lazy {
            DateTimeComponents.Format {
                char('T')
                hour()
                minute()
                alternativeParsing({
                    // intentionally empty
                }) {
                    second()
                    optional {
                        char('.')
                        secondFraction(1, 9)
                    }
                }
            }
        }

        val isoBasicFormat by lazy {
            // ToDo: Fail to parse 20250320T185500Z
            DateTimeComponents.Format {
                date(LocalDate.Formats.ISO_BASIC)
                // ToDo: LocalTime.Formats.ISO_BASIC should be added to kotlinx-datetime
//                char('T')
//                time(LocalTime.Formats.ISO)
                dateTimeComponents(ISO_TIME_BASIC)
                offset(UtcOffset.Formats.ISO_BASIC)
            }
        }

        val isoFormat by lazy {
            DateTimeComponents.Format {
                date(LocalDate.Formats.ISO)
                char('T')
                time(LocalTime.Formats.ISO)
                offset(UtcOffset.Formats.ISO)
            }
        }
    }
}