package org.molap.exporter

import org.molap.dataframe.DataFrame

object DataFrameExporter {
    fun <R,C,V> exportCSV(dataFrame: DataFrame<R,C,V>): String {
        return exportDelimited(dataFrame, ",")
    }

    internal fun <R,C,V> exportDelimited(dataFrame: DataFrame<R,C,V>, delimiter: String): String {
        val newLine = "\n"
        val sb = StringBuilder("\ufeff")
        val writer: DataFrameWriter = DelimitedDataFrameWriter(StringDataFrameOutput(sb), delimiter, newLine)
        export(dataFrame, writer)
        return sb.toString()
    }

    fun <R,C,V> export(dataFrame: DataFrame<R,C,V>, writer: DataFrameWriter) {
        val export = DelimitedDataFrameExport(writer)
        export.write(dataFrame)
        export.close()
    }
}
