package org.molap.importer

import kotlin.reflect.KClass

interface DataFrameReader {
    fun getColumnName(column: Int): Any?

    fun getClass(column: Int): KClass<*>

    val columnCount: Int

    val rowCount: Int

    fun nextRow()

    fun nextColumn(): Any?

    fun hasMoreRow(): Boolean

    fun hasMoreColumn(): Boolean

    fun close()

    val lineNumber: Int

    val row: Int

    val column: Int

    val isHasClassHeader: Boolean
}
