/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.series

abstract class AbstractSeries<K, V> : Series<K, V> {
//    override fun pow(exponent: Double?): Series<K, Double?>? {
//        val keys: MutableSet<K> = HashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        val array = keys.toArray() as Array<K>
//        val values = arrayOfNulls<Double>(keys.size())
//        for (i in array.indices) {
//            val k = array[i]
//            val v1: V? = get(k)
//            if (v1 is Number) {
//                values[i] = java.lang.Math.pow((v1 as Number).doubleValue(), exponent)
//            }
//        }
//        return IndexedSeries<K, Double>(name.toString() + "^" + exponent, values, array)
//    }
//
//    override fun divide(other: Series<K, V>?): Series<K, Double?>? {
//        val keys: MutableSet<K> = HashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        for (k in other!!.keys()!!) {
//            keys.add(k)
//        }
//        val array = keys.toArray() as Array<K>
//        val values = arrayOfNulls<Double>(keys.size())
//        for (i in array.indices) {
//            val k = array[i]
//            val v1: V? = get(k)
//            val v2 = other[k]
//            if (v1 is Number && v2 is Number) {
//                values[i] = (v1 as Number).doubleValue() / (v2 as Number).doubleValue()
//            }
//        }
//        return IndexedSeries<K, Double>(name.toString() + "/" + other.name, values, array)
//    }
//
//    override fun multiply(other: Series<K, V>?): Series<K, Double?>? {
//        val keys: MutableSet<K> = HashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        for (k in other!!.keys()!!) {
//            keys.add(k)
//        }
//        val array = keys.toArray() as Array<K>
//        val values = arrayOfNulls<Double>(keys.size())
//        for (i in array.indices) {
//            val k = array[i]
//            val v1: V? = get(k)
//            val v2 = other[k]
//            if (v1 is Number && v2 is Number) {
//                values[i] = (v1 as Number).doubleValue() * (v2 as Number).doubleValue()
//            }
//        }
//        return IndexedSeries<K, Double>(name.toString() + "*" + other.name, values, array)
//    }
//
//    override fun subtract(other: Series<K, V>?): Series<K, Double?>? {
//        val keys: MutableSet<K> = HashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        for (k in other!!.keys()!!) {
//            keys.add(k)
//        }
//        val array = keys.toArray() as Array<K>
//        val values = arrayOfNulls<Double>(keys.size())
//        for (i in array.indices) {
//            val k = array[i]
//            val v1: V? = get(k)
//            val v2 = other[k]
//            if (v1 is Number && v2 is Number) {
//                values[i] = (v1 as Number).doubleValue() - (v2 as Number).doubleValue()
//            }
//        }
//        return IndexedSeries<K, Double>(name.toString() + "-" + other.name, values, array)
//    }
//
//    override fun add(other: Series<K, V>?): Series<K, Double?>? {
//        val keys: MutableSet<K> = HashSet()
//        for (k in keys()!!) {
//            keys.add(k)
//        }
//        for (k in other!!.keys()!!) {
//            keys.add(k)
//        }
//        val array = keys.toArray() as Array<K>
//        val values = arrayOfNulls<Double>(keys.size())
//        for (i in array.indices) {
//            val k = array[i]
//            val v1: V? = get(k)
//            val v2: V? = other[k]
//            if (v1 is Number && v2 is Number) {
//                values[i] = (v1 as Number).doubleValue() + (v2 as Number).doubleValue()
//            } else if (v1 is Number && v2 == null) {
//                values[i] = (v1 as Number).doubleValue()
//            } else if (v2 is Number && v1 == null) {
//                values[i] = (v2 as Number).doubleValue()
//            }
//        }
//        return IndexedSeries<K, Double>(name.toString() + "+" + other.name, values, array)
//    }

    override fun indexMax(): K {
        return null!!
    }

    override fun indexMin(): K {
        return null!!
    }

    override fun countUnique(): Int? {
        return null
    }

    override fun max(): V {
        var max: V? = null
        for (k in keys()!!) {
            val value: V? = get(k)
            if (value != null && value is Comparable<*>) {
                if (max == null || (value as Comparable<Any>).compareTo(max) > 0) {
                    max = value
                }
            }
        }
        return max as V
    }

    override fun min(): V {
        var min: V? = null
        for (k in keys()!!) {
            val value: V? = get(k)
            if (value != null && value is Comparable<*>) {
                if (min == null || (value as Comparable<Any>).compareTo(min) < 0) {
                    min = value
                }
            }
        }
        return min as V
    }

    override fun median(): V {
        return null!!
    }

    override fun meanAbsoluteDeviation(): Double? {
        return null
    }

    override fun mean(): Double? {
        val count = count()
        return if (count != null && count > 0) {
            sum()!! / count
        } else {
            null
        }
    }

    override fun count(): Int? {
        var count = 0
        for (k in keys()!!) {
            val value: V? = get(k)
            if (value != null) {
                count++
            }
        }
        return count
    }

    override fun sum(): Double? {
        var sum = 0.0
        for (k in keys()!!) {
            val value: V? = get(k)
            if (value != null && value is Number) {
                sum += (value as Number).toDouble()
            }
        }
        return sum
    }

    override fun print() {
        for (k in keys()!!) {
            val value: V? = get(k)
            println(k.toString() + "\t" + value)
        }
        println("Name: $name, type: $type")
    }

    override fun toString(): String {
        return if (name != null) {
            name.toString()
        } else {
            super.toString()
        }
    }

//    override fun equals(o: Any?): Boolean {
//        if (this === o) return true
//        if (o !is Series<*, *>) return false
//        return name == o.name
//    }

    //    @Override
//    fun identitcal(o: Series<*, *>): Boolean {
//        if (this === o) return true
//        if (o !is Series<*, *>) return false
//        if (name != o.name) return false
//        if (!type!!.equals(o.type)) return false
//        val iterator1: Iterator = keys()!!.iterator()
//        val iterator2: Iterator = o.keys()!!.iterator()
//        while (iterator1.hasNext()) {
//            if (!iterator2.hasNext()) {
//                return false
//            }
//            val o1: Any = iterator1.next()
//            val o2: Any = iterator2.next()
//            if (!Objects.equals(o1, o2)) {
//                return false
//            }
//        }
//        return !iterator2.hasNext()
//    }

//    override fun hashCode(): Int {
////        assert(name != null) { javaClass }
//        return name.hashCode()
//    }
}