package org.molap.series

import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class ImmutableSeries<V>(override val name: Any, private val values: Array<out V>, private val index: UniqueIndex<Int> = IntegerRangeUniqueIndex(0, values.size - 1)) : AbstractSeries<Int, V>(), Series<Int, V> {
    override val type: KClass<out Any> by lazy {
        var commonType : KClass<out Any>? = null
        for (value in values) {
            if(value != null) {
                if (commonType == null) {
                    commonType = value!!::class
                } else {
                    if (commonType != value!!::class) {
                        commonType = Any::class
                        break;
                    }
                }
            }
        }
        if(commonType != null) {
            commonType
        } else {
            Any::class
        }
   }

//    constructor(name: Any, values: Array<out V>) {
//        this.name = name
//        this.values = values
//        index = IntegerRangeUniqueIndex(0, values.size - 1)
//    }

//    private constructor(values: Array<V>, index: UniqueIndex<Int>) {
//        name = null
//        this.values = values
//        this.index = index
//    }

    //    override val type: KClass<out Any>
//        get() = values.component1()!!::class
//    val type: KClass<out Any>
//        get() = values.component1()!!::class
//    get() = V::class

    override fun get(key: Int): V {
        return values[key]
    }

    override fun getKey(i: Int): Int {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: Int): Int {
        return index.getAddress(key)
    }

    override fun keys(): Iterable<Int> {
        return index.keys()
    }

//    override fun count(): Int? {
//        return values.count()
//    }
//
//    override fun sum(): Double? {
//        return values.sumOf { if(it is Double) it else 0.0 }
//    }

//    fun <L> reindex(vararg keys: L?): Series<L?, V?>? {
//        return null
//    }

//    fun head(count: Int): Series<Int, V> {
//        return reindex(index.head(count))
//    }

//    fun tail(count: Int): Series<Int, V> {
//        return reindex(index.tail(count))
//    }

//    fun <K> reindex(index: UniqueIndex<K>): Series<K, V> {
//        return IndexedSeries<K, V>(name, values, index)
//    }
}
