package org.molap.series

import org.molap.index.IntegerRangeUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class LongSeries : AbstractSeries<Int, Long?>, MutableSeries<Int, Long?> {
    override val name: Any?
    private val available: BooleanArray?
    private val values: LongArray
    private val index: UniqueIndex<Int>

    constructor(values: LongArray) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(name: Any?, values: LongArray) {
        this.name = name
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        available = null
    }

    constructor(values: LongArray, available: BooleanArray?) {
        name = null
        this.values = values
        index = IntegerRangeUniqueIndex(0, values.size - 1)
        this.available = available
    }

    private constructor(values: LongArray, index: UniqueIndex<Int>) {
        name = null
        this.values = values
        this.index = index
        available = null
    }

    override val type: KClass<Any>
        get() = Long::class as KClass<Any>

    override operator fun get(key: Int): Long? {
        return if (isNull(key)) null as Long? else values[key]
    }

    fun isNull(key: Int): Boolean {
        return available != null && !available[key]
    }

    fun getDouble(key: Int): Double {
        return values[key].toDouble()
    }

    override fun getKey(i: Int): Int {
        return index.getKey(i)
    }

    override fun size(): Int {
        return index.size
    }

    override fun getAddress(key: Int): Int {
        return index.getAddress(key)
    }

    override operator fun set(key: Int, value: Long?) {
        if(value != null) {
            values[key] = value
            if(available != null) {
                available[key] = true
            } else {
                // ToDo: Exception?
            }
        } else {
            if(available != null) {
                available[key] = false
            } else {
                // ToDo: Exception?
            }
        }
    }

    override fun keys(): Iterable<Int> {
        return index.keys()
    }

    fun <L> reindex(vararg keys: L): Series<L, Long>? {
        return null
    }

    fun head(count: Int): Series<Int, Long>? {
        return reindex(index.head(count))
    }

    fun tail(count: Int): Series<Int, Long>? {
        return reindex(index.tail(count))
    }

    fun <K> reindex(index: UniqueIndex<K>?): Series<K, Long>? {
//        return new IndexedSeries<K,Double>(getName(), values, index);
        return null
    }
}
