/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.selection.MutableSelection

/**
 * Created by luc on 11/07/16.
 */
class DefaultDistributionDimension<Row, Column, Value, Bin>(
    dataFrame: SubsetDataFrame<Row, Column, Value>,
    private val column: Column,
    filteringCallback: FilteringCallback<Row>,
    selection: MutableSelection<Row>?,
    distributionStrategy: DistributionDimension.DistributionStrategy<Value, Bin>
) : DefaultBinningDimension<Row, Column, Value, Bin>(dataFrame, column, filteringCallback, selection, null),
    DistributionDimension<Row, Value, Bin> {
    override var distributionStrategy: DistributionDimension.DistributionStrategy<Value, Bin>? = null
        set(distributionStrategy) {
            if (this.distributionStrategy !== distributionStrategy) {
                field = distributionStrategy
                val binningStrategy: SingleBinningDimension.SingleBinningStrategy<Row, Bin> = object : SingleBinningDimension.SingleBinningStrategy<Row, Bin> {
                    override fun isBinnable(row: Row): Boolean {
                        return distributionStrategy!!.isBinnable(dataFrame.unfilteredDataFrame.getValueAt(row, column))
                    }

                    override fun rowToBin(row: Row): Bin {
                        return distributionStrategy!!.valueToBin(dataFrame.unfilteredDataFrame.getValueAt(row, column))
                    }
                }
                this.binningStrategy = binningStrategy
            }
        }

    override fun getBinStartValue(bin: Bin): Double {
        return distributionStrategy!!.getBinStartValue(bin)
    }

    override fun getBinEndValue(bin: Bin): Double {
        return distributionStrategy!!.getBinEndValue(bin)
    }

    override val minValue: Double
        get() = distributionStrategy!!.minValue
    override val maxValue: Double
        get() = distributionStrategy!!.maxValue

    init {
        this.distributionStrategy = distributionStrategy
    }
}