/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.annotation.Synchronized
import com.macrofocus.common.collection.TIntArrayList
import com.macrofocus.common.collection.TIntList
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import com.macrofocus.common.filter.MutableFilter
import org.molap.index.UniqueIndex

class DefaultItemsDimension<Row, Column, Value>(
    dataFrame: SubsetDataFrame<Row, Column, Value>,
    filter: MutableFilter<Row>,
    filteringCallback: FilteringCallback<Row>
) : AbstractDimension<Row>(), ItemsDimension<Row, Column, Value> {
    private val dataFrame: SubsetDataFrame<Row, Column, Value>
    override val filter: MutableFilter<Row>
    private val filteringCallback: FilteringCallback<Row>
    override var activeIndices: IntArray? = null
        private set
    override val name: String?
        get() = "Items"
    override val isReducable: Boolean
        get() = false

    override fun reduce(otherActiveIndices: IntArray?) {}
    override fun markDirty() {}
    override fun materializeIndex() {}

    override fun filterAll() {
        filter.clearFilter()
        scheduleUpdateFilter()
    }

    @Synchronized
    protected override fun updateFilter() {
        val oldIndices = activeIndices
        val newIndices = updateActiveIndices()

//        if((filtered != null && filtered.length > 0) || (unfiltered != null && unfiltered.length > 0)) {
        filteringCallback.filteringChanged(FilteringEvent<Row>(this, IndicesIterable(dataFrame.unfilteredDataFrame, object : IndicesSupplier {
            override fun get(): IntArray? {
                return dataFrame.computeFiltered(oldIndices, newIndices)
            }
        }), IndicesIterable(dataFrame.unfilteredDataFrame, object : IndicesSupplier {
            override fun get(): IntArray? {
                return dataFrame.computeUnfiltered(oldIndices, newIndices)
            }
        })))
        //        }
    }

    fun updateActiveIndices(): IntArray? {
        if (filter.isEnabled && filter.isActive) {
            val rowIndex: UniqueIndex<Row> = dataFrame.unfilteredDataFrame.rowIndex
            val list: TIntList = TIntArrayList()
            for (key in rowIndex.keys()) {
                if (!filter.isFiltered(key)) {
                    val index: Int = rowIndex.getAddress(key)
                    list.add(index)
                }
            }
            activeIndices = list.toIntArray()
        } else {
            activeIndices = null
        }
        return activeIndices
    }

    init {
        this.dataFrame = dataFrame
        this.filter = filter
        this.filter.addFilterListener(object : FilterListener<Row> {
            override fun filterChanged(event: FilterEvent<Row>) {
                scheduleUpdateFilter()
            }
        })
        this.filteringCallback = filteringCallback
        updateActiveIndices()
    }
}