/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import org.molap.dataframe.DataFrame
import org.molap.dataframe.ReMappedRecipe
import org.molap.index.UniqueIndex

internal class DefaultReMappedRecipe<Row, Column, Value>(private val dataFrame: DataFrame<Row, Column, Value>) : ReMappedRecipe<Row, Column> {
    override fun buildRowIndex(): UniqueIndex<Row> {
        return dataFrame.rowIndex
    }

    override fun buildColumnIndex(): UniqueIndex<Column> {
        return dataFrame.columnIndex
    }
}