/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.collection.TObjectDoubleMap
import com.macrofocus.common.collection.adjustOrPutValue
import com.macrofocus.common.collection.adjustValue

class DefaultReducer<Row, Bin> : Reducer<Row, Bin> {
    override fun add(sums: TObjectDoubleMap<Bin>, bin: Bin, row: Row): Double {
        return sums.adjustOrPutValue(bin, 1.0, 1.0)
    }

    override fun remove(sums: TObjectDoubleMap<Bin>, bin: Bin, row: Row): Double {
        return if (sums.get(bin)!! > 1.0) {
            sums.adjustValue(bin, -1.0)
            sums.get(bin)!!
        } else {
            sums.remove(bin)
            0.0
        }
    }

    override fun getNumber(row: Row): Number {
        return one
    }

    companion object {
        private val one: Number = 1
    }
}