/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.selection.MutableSelection
/**
 * Created by luc on 11/07/16.
 */
interface MultiBinningDimension<Row, Bin> : BinningDimension<Row, Bin> {
    var binningStrategy: MultiBinningStrategy<Row, Bin>?
    override fun getBins(row: Row): Iterable<Bin>?
    abstract override val filterExact: MutableSelection<Bin>?
    override fun filterExact(vararg bins: Bin)
    override fun filterExactIterable(bins: Iterable<Bin>)
    val defaultSortedArrayFilter: SortedArrayFilter<Bin>?
    fun createSortedArrayFilter(bin: Bin): SortedArrayFilter<Bin>?
    interface MultiBinningStrategy<Row, Bin> : BinningDimension.BinningStrategy<Row, Bin> {
        fun rowToBins(row: Row): Array<Bin>
    }

    interface SortedArrayFilter<Bin> {
        fun evaluate(): IntArray?
        fun or(other: SortedArrayFilter<Bin>): SortedArrayFilter<Bin>
        fun or(others: Iterable<SortedArrayFilter<Bin>>): SortedArrayFilter<Bin>
        fun and(other: SortedArrayFilter<Bin>): SortedArrayFilter<Bin>
        fun and(others: Iterable<SortedArrayFilter<Bin>>): SortedArrayFilter<Bin>
    }
}