/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation

import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import kotlin.reflect.KClass

class ConstantAggregation(cl: KClass<out Any>, value: Any?) : AbstractAggregation<Any?>() {
    private val cl: KClass<out Any>
    private val value: Any?

    constructor(value: Any?) : this(if (value != null) value!!::class else Any::class, value) {}

    override val type: KClass<Any>
        get() = value!!::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        return value
    }

    override fun toString(): String {
        return value?.toString() ?: "(null)"
    }

    init {
        this.cl = cl
        this.value = value
    }
}