/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.math.sqrt
import kotlin.reflect.KClass

class StdDevAggregation : AbstractAggregation<Any?> {
    private val column: Series<Any?, Any?>
    private val sum: Series<Any?, Any?>?
    private val count: Series<Any?, Any?>?

    constructor(column: Series<Any?, Any?>) {
        this.column = column
        sum = null
        count = null
    }

    constructor(uncorrectedSumOfSquares: Series<Any?, Any?>, sum: Series<Any?, Any?>?, count: Series<Any?, Any?>?) {
        column = uncorrectedSumOfSquares
        this.sum = sum
        this.count = count
    }

    override val type: KClass<Any>
        get() = Double::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val d = cuboid!!.getDistributiveStatistics(group, column, null)
        return if (count != null) {
            val p = cuboid.getDistributiveStatistics(group, count, null)
            val s = cuboid.getDistributiveStatistics(group, sum!!, null)
            val mean = s!!.sum!! / p!!.sum!!
            val variance = d!!.sum!! / p.sum!! - mean * mean
            sqrt(variance)
        } else {
            d!!.standardDeviation
        }
    }

    override fun toString(): String {
        return "StdDev(" + column.name + ")"
    }
}