/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.aggregation


import org.molap.aggregates.cube.DistributiveStatistics
import org.molap.aggregates.cube.Group
import org.molap.aggregates.cuboid.Cuboid
import org.molap.series.Series
import kotlin.jvm.JvmOverloads
import kotlin.reflect.KClass

class SumAggregation @JvmOverloads constructor(private val column: Series<Any?, Any?>, private val filter: DistributiveStatistics.RowFilter<Any?>? = null) : AbstractAggregation<Any?>() {
    override val type: KClass<Any>
        get() = Double::class as KClass<Any>

    override fun compute(cuboid: Cuboid?, group: Group?): Any? {
        val distributiveStatistics = cuboid!!.getDistributiveStatistics(group, column, filter)
        return distributiveStatistics?.sum
    }

    override fun toString(): String {
        return "Sum(" + column.name + ")"
    }
}