/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

open class ArrayGroup protected constructor(vararg path: Any?) : Group {
    override val path: Array<out Any?>? = path
    override fun drillUp(): Group? {
        return if (path!!.size > 0) {
            getDrillUp(path)
        } else {
            null
        }
    }

    override fun drillDown(valueAt: Any?): Group {
        return getDrillDown(valueAt, path!!)
    }

    override val last: Any
        get() = path!![path!!.size - 1]!!

    override fun getPath(i: Int): Any? {
        return path!![i]!!
    }

    override val pathLength: Int
        get() = path!!.size

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o !is Group) return false
        val path1: Group? = o as Group?
        return path.contentEquals(path1!!.path)
    }

    override fun hashCode(): Int {
        return path.contentHashCode()
    }

    //    @Override
    //    public int compareTo(Object o) {
    //        if (this == o) return 0;
    //        if (!(o instanceof Group)) return -1;
    //
    //        Group group = (Group) o;
    //
    //        int length = Math.min(group.path.length, path.length);
    //
    //        for (int i=0; i<length; i++) {
    //            Comparable o1 = (Comparable)path[i];
    //            Comparable o2 = (Comparable)group.path[i];
    //            if(o1 != null) {
    //                if(o2 != null) {
    //                    int equals = o1.compareTo(o2);
    //                    if(equals != 0) {
    //                        return o1.compareTo(o2);
    //                    }
    //                } else {
    //                    return 1;
    //                }
    //            } else {
    //                if(o2 != null) {
    //                    return -1;
    //                }
    //            }
    //        }
    //
    //        return group.path.length < path.length ? 1: 0;
    //    }
    override fun toString(): String {
        return "ArrayGroup{" +
                "path=" + path.contentToString() +
                '}'
    }

    override fun startsWith(group: Group?): Boolean {
        if (this === group) return true
        if (group == null) return false
        val length = path!!.size
        val otherPath: Array<out Any?> = group.path!!
        if (otherPath.size >= length) return false
        for (i in otherPath.indices) {
            val o1 = path!![i]
            val o2 = otherPath[i]
            if (!(if (o1 == null) o2 == null else o1 == o2)) return false
        }
        return true
    }

    companion object {
        operator fun get(vararg path: Any): Group {
            return ArrayGroup(*path)
        }

        private fun getDrillDown(last: Any?, vararg path: Any): Group {
            val newPath = arrayOfNulls<Any>(path.size + 1)
            com.macrofocus.common.collection.arraycopy(path, 0, newPath, 0, path.size)
            newPath[newPath.size - 1] = last
            return get(newPath)
        }

        private fun getDrillUp(vararg path: Any?): Group {
            val newPath = arrayOfNulls<Any>(path.size - 1)
            com.macrofocus.common.collection.arraycopy(path, 0, newPath, 0, newPath.size)
            return get(newPath)
        }
    }
}