/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.aggregates.cube

class MedianOf3PivotingStrategy : PivotingStrategyInterface {
    /**{@inheritDoc}
     * This in specific makes use of median of 3 pivoting.
     * @return The index corresponding to a pivot chosen between the
     * first, middle and the last indices of the array slice
     */
    override fun pivotIndex(work: DoubleArray, begin: Int, end: Int): Int {
        val inclusiveEnd = end - 1
        val middle = begin + (inclusiveEnd - begin) / 2
        val wBegin = work[begin]
        val wMiddle = work[middle]
        val wEnd = work[inclusiveEnd]
        return if (wBegin < wMiddle) {
            if (wMiddle < wEnd) {
                middle
            } else {
                if (wBegin < wEnd) inclusiveEnd else begin
            }
        } else {
            if (wBegin < wEnd) {
                begin
            } else {
                if (wMiddle < wEnd) inclusiveEnd else middle
            }
        }
    }
}