/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.convert

import kotlin.reflect.KClass

/**
 * Created by luc on 27/10/14.
 */
class ToBooleanTypeConverter : org.molap.convert.TypeConverter {
    override fun isConvertable(input: TypeConverter.Input): Boolean {
        if (input.getType() !== Boolean::class) {
            var allNull = true
            for (row in 0..<input.size()) {
                val v: Any? = input.get(row)
                if (v != null) {
                    if (v is String) {
                        val s = v.trim { it <= ' ' }
                        if (s != "") {
                            allNull = false
                            if (!s.equals("true", ignoreCase = true) && !s.equals("false", ignoreCase = true)) {
                                return false
                            }
                        }
                    } else if (v !is Boolean) {
                        return false
                    }
                }
            }
            return !allNull
        } else {
            return false
        }
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "" && (s.equals("true", ignoreCase = true) || s.equals("false", ignoreCase = true))) {
                        output.set(row, s.toBoolean())
                    } else {
                        output.set(row, null)
                    }
                } else if (v !is Boolean) {
                    output.set(row, null)
                }
            }
        }
        return Boolean::class
    }

    override val type: KClass<*>
        get() = Boolean::class
}
