package org.molap.convert

import kotlinx.datetime.LocalDate
import kotlinx.datetime.format.DateTimeFormat
import kotlinx.datetime.format.Padding
import kotlinx.datetime.format.char
import kotlin.reflect.KClass

class ToDateTypeConverter : TypeConverter {
    val dateFormats: Array<DateTimeFormat<LocalDate>> = arrayOf<DateTimeFormat<LocalDate>>(
//        DateTimeFormat.getFormat("MM/dd/yyyy"),
//        DateTimeFormat.getFormat("MM/dd/yy"),
//        DateTimeFormat.getFormat("M/d/yyyy"),
//        DateTimeFormat.getFormat("yyyy-MM-dd"),
        // "dd.MM.yyyy HH:mm:ss"
        LocalDate.Format {
            dayOfMonth(padding = Padding.NONE)  // dd
            char('.')                          // .
            monthNumber(padding = Padding.NONE) // MM
            char('.')                          // .
            year()                             // yyyy
        },
//        DateTimeFormat.getFormat("dd.MM.yyyy"),
//        DateTimeFormat.getFormat("d.M.yyyy"),
    )

    private var dateFormat: DateTimeFormat<LocalDate>? = null

    @Throws(IllegalArgumentException::class)
    private fun parse(format: DateTimeFormat<LocalDate>, value: String): LocalDate? {
        return format.parse(value)
    }

    override fun isConvertable(input: TypeConverter.Input): Boolean {
        if (input.getType() !== LocalDate::class) {
            for (format in dateFormats) {
                if (isConvertableToDate(input, format)) {
                    this.dateFormat = format
                    return true
                }
            }
        }
        this.dateFormat = null
        return false
    }

    override fun convert(input: TypeConverter.Input, output: TypeConverter.Output): KClass<*> {
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        var parsed = false
                        try {
                            output.set(row, parse(dateFormat!!, s))
                            parsed = true
                        } catch (e1: IllegalArgumentException) {
                            e1.printStackTrace()
                        }
                        if (!parsed) {
                            output.set(row, null)
                        }
                    } else {
                        output.set(row, null)
                    }
                } else if (v !is LocalDate) {
                    output.set(row, null)
                }
            }
        }
        return LocalDate::class
    }

    private fun isConvertableToDate(input: TypeConverter.Input, format: DateTimeFormat<LocalDate>): Boolean {
        var allNull = true
        for (row in 0..<input.size()) {
            val v: Any? = input.get(row)
            if (v != null) {
                if (v is String) {
                    val s = v.trim { it <= ' ' }
                    if (s != "") {
                        allNull = false
                        var parsed = false
                        try {
                            parse(format, s)
                            parsed = true
                        } catch (e1: IllegalArgumentException) {
//                            println("Could not parse $s because of ${e1.message}")
                        }
                        if (!parsed) {
                            return false
                        }
                    }
                } else if (v !is LocalDate) {
                    return false
                }
            }
        }
        return !allNull
    }

    override val type: KClass<*>
        get() = LocalDate::class
}
