package org.molap.dataframe

import org.molap.index.DefaultUniqueIndex
import org.molap.index.MultiKey
import org.molap.index.UniqueIndex

abstract class AbstractMutableDataFrame<R, C, V> : AbstractDataFrame<R, C, V>(),
    MutableDataFrame<R, C, V> {
    override fun reindexRowsUsingColumn(column: C): MutableDataFrame<V, C, V> {
        return ReIndexedDataFrame<V, C, V, R, C>(this, object : ReIndexRecipe<V, C> {
            override fun buildRowIndex(): UniqueIndex<V> {
                var r = 0
                val keys = arrayOfNulls<Any>(rowCount)
                for (row in rows()) {
                    keys[r++] = getValueAt(row, column)
                }
                return DefaultUniqueIndex(keys) as UniqueIndex<V>
            }

            override fun buildColumnIndex(): UniqueIndex<C> {
                return columnIndex
            }
        })
    }

    override fun reindexRowsUsingColumns(vararg rows: C): MutableDataFrame<MultiKey?, C, V> {
        return ReIndexedDataFrame<MultiKey?, C, V, R, C>(this, object : ReIndexRecipe<MultiKey?, C> {
            override fun buildRowIndex(): UniqueIndex<MultiKey?> {
                var r = 0
                val keys: Array<MultiKey?> = arrayOfNulls<MultiKey>(rowCount)
                for (row in rows()) {
                    val values = arrayOfNulls<Any>(rows.size)
                    var c = 0
                    for (column in rows) {
                        values[c++] = getValueAt(row, column)
                    }
                    val key = MultiKey(values)
                    keys[r++] = key
                }
                return DefaultUniqueIndex(keys) as UniqueIndex<MultiKey?>
            }

            override fun buildColumnIndex(): UniqueIndex<C> {
                return columnIndex
            }
        })
    }
}
