package org.molap.dataframe

/**
 * The listener interface for receiving "interesting" events about a selection.
 *
 * @param <R> the type of row keys
 * @param <C> the type of column keys
</C></R> */
interface DataFrameListener<R, C> {
    /**
     * Called whenever the structure or the values of the data frame changes.
     *
     * @param event the event that characterizes the change.
     */
    fun dataFrameChanged(event: DataFrameEvent<R, C>)
}
