package org.molap.dataframe

import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex
import kotlin.reflect.KClass

class ListDataFrame<R,C,V>(list: List<R>, private val columns: Map<C,Column<R,V>>) : AbstractDataFrame<R,C,Any?>() {
    override fun getColumnClass(column: C): KClass<*> {
        return columns[column]!!.type
    }

    override fun getValueAt(row: R, column: C): V {
        return columns[column]!!.values(row)
    }

    override val rowIndex: UniqueIndex<R> = DefaultUniqueIndex(list, true)

    override val columnIndex: UniqueIndex<C> = DefaultUniqueIndex(columns.keys, true)

    override fun getRowClass(row: R): KClass<*>? {
        return Any::class
    }}
