package org.molap.dataframe

class MapDataFrameBuilder<R,M,C>(
    private val rows: Map<R,M>
) {
    val columns = mutableMapOf<C, Column<M, Any?>>()

    inline infix fun <reified V> C.to(noinline values: M.() -> V) {
        // Optional: make column() return Column<M, Any?> should this cast ever become a problem
        columns[this] = column<M,V>(values)
    }

    fun build(): MapDataFrame<R, M, C, Any?> {
        return MapDataFrame(rows, columns)
    }
}