package org.molap.dataframe

import org.molap.aggregates.aggregation.*
import org.molap.series.Series

fun DataFrame<*,*,*>.getDataFrameAggregation(): DataFrameAggregation {
    return DataFrameAggregation()
}

fun <Column> DataFrame<*,Column,*>.getFirst(column: Column): FirstAggregation {
    return FirstAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun DataFrame<*,*,*>.getConstant(value: Any?): ConstantAggregation {
    return ConstantAggregation(value)
}

//    fun getRandom(min: Double, max: Double): RandomAggregation? {
//        return RandomAggregation(min, max)
//    }

fun <Column> DataFrame<*,Column,*>.getSum(column: Column): SumAggregation {
    return SumAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getCount(column: Column): CountAggregation {
    return CountAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getDistributiveStatistics(column: Column): DistributiveStatisticsAggregation {
    return DistributiveStatisticsAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getMin(column: Column): MinAggregation {
    return MinAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getMax(column: Column): MaxAggregation {
    return MaxAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getMean(column: Column): MeanAggregation {
    return MeanAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getVariance(column: Column): VarianceAggregation {
    return VarianceAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getVarianceByPopulation(column: Column, population: Column): VarianceAggregation {
    return VarianceAggregation(getColumn(column) as Series<Any?, Any?>, getColumn(population) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getStdDev(column: Column): StdDevAggregation {
    return StdDevAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getUnivariateStatistics(column: Column): UnivariateStatisticsAggregation? {
    return UnivariateStatisticsAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getMedian(column: Column): MedianAggregation? {
    return MedianAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getFirstQuartile(column: Column): FirstQuartileAggregation? {
    return FirstQuartileAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getThirdQuartile(column: Column): ThirdQuartileAggregation {
    return ThirdQuartileAggregation(getColumn(column) as Series<Any?, Any?>)
}

//fun <Column> DataFrame<*,Column,*>.getWeightedSum(weight: Column, column: Column): Aggregation<*> {
//    return SumAggregation(getColumn(column)!!.multiply(getColumn(weight)))
//}

//fun <Column> DataFrame<*,Column,*>.getWeightedMean(weight: Column, column: Column): Aggregation<*> {
//    return getWeightedSum(weight, column).divide(getSum(weight))
//}

fun <Column> DataFrame<*,Column,*>.getCountDistinct(column: Column): CountDistinctAggregation {
    return CountDistinctAggregation(getColumn(column) as Series<Any?, Any?>)
}

fun <Column> DataFrame<*,Column,*>.getCountDistinctWithNull(column: Column): CountDistinctWithNullAggregation {
    return CountDistinctWithNullAggregation(getColumn(column) as Series<Any?, Any?>)
}

//fun <Column> DataFrame<*,Column,*>.getCentroid(column: Column?): CentroidAggregation? {
//    return CentroidAggregation(getColumn(column))
//}
