package org.molap.dataframe

import org.molap.index.DefaultUniqueIndex
import org.molap.index.UniqueIndex

fun <Row,Column,V> DataFrame<Row,Column,V>.orderRows(vararg sortKeys: SortKey<Column>): DataFrame<Row, Column, V>? {
    return ReMappedDataFrame(this, OrderReMappedRecipe(this, *sortKeys))
}

//fun <Row,Column,V> DataFrame<Row,Column,V>.reindexColumns(vararg columns: Column): DataFrame<Row, Column, V> {
//    return ReIndexedDataFrame(this, ColumnsReIndexRecipe<Any?>(*columns))
//}
//
//fun <Row,Column,V> DataFrame<Row,Column,V>.remapColumns(vararg columns: Column?): DataFrame<Row, Column, V> {
//    return ReMappedDataFrame(this, ColumnsReMappedRecipe(*columns))
//}
//
//fun <Row,Column,V> DataFrame<Row,Column,V>.removeColumns(vararg columns: Column?): DataFrame<Row?, Column?, V?>? {
//    return ReMappedDataFrame(this, RemoveReMappedRecipe(*columns))
//}

//fun <Row,Column,V> DataFrame<Row,Column,V>.append(dataFrame: DataFrame<Row?, Column?, V?>?): DataFrame<Row?, Column?, V?>? {
//    return AppendDataFrame<Row?, Column?, V?>(this, dataFrame)
//}

//fun <Row,Column,V> DataFrame<Row,Column,V>.appendAndReindex(dataFrame: DataFrame<Row?, Column?, V?>?): DataFrame<Int?, Column?, V?>? {
//    return AppendAndReindexDataFrame<Row?, Column?, V?>(this, dataFrame)
//}

//fun <Row,Column,V> DataFrame<Row,Column,V>.filter(filter: MutableFilter<Row?>?): FilterDataFrame? {
//    return FilterDataFrame<Row?, Column?, V?>(this, filter)
//}

//fun <Row,Column,V> DataFrame<Row,Column,V>.removeDuplicates(vararg columns: Column?): DataFrame<Row?, Column?, V?>? {
//    return ReMappedDataFrame(this, RemoveDuplicatesReMappedRecipe(*columns))
//}

//fun <Row,Column,V> DataFrame<Row,Column,V>.getStatistics(column: Column?): UnivariateStatistics? {
//    return if (statisticsMap!!.containsKey(column)) {
//        statisticsMap[column]
//    } else {
//        val univariateStatistics = UnivariateStatistics(rows(), getColumn(column))
//        statisticsMap[column] = univariateStatistics
//        univariateStatistics
//    }
//}

    private class SortComparator<Row,Column,V>(val dataFrame: DataFrame<Row,Column,V>, vararg val sortKeys: SortKey<Column>) : Comparator<Row> {
//        private val sortKeys: Array<SortKey<Column>> = sortKeys
        override fun compare(o1: Row, o2: Row): Int {
            for (sortKey in sortKeys) {
                val compare: Int = sortKey.compare(dataFrame, o1, o2)
                if (compare != null && compare != 0) {
                    return compare
                }
            }
            val x = dataFrame.getRowAddress(o1)
            val y = dataFrame.getRowAddress(o2)
            return if (x < y) -1 else if (x == y) 0 else 1
        }
    }

//    private inner class ColumnsReIndexRecipe<C>(vararg columns: C?) : ReIndexRecipe<Row?, C?> {
//        private val columns: Array<C?>?
//        fun buildRowIndex(): UniqueIndex<Row?>? {
//            return rowIndex
//        }
//
//        fun buildColumnIndex(): UniqueIndex<C?>? {
//            return DefaultUniqueIndex.< C > fromArray < C ? > columns
//        }
//
//        init {
//            this.columns = columns
//        }
//    }

    private class OrderReMappedRecipe<Row,Column,V>(val dataFrame: DataFrame<Row,Column,V>, vararg sortKeys: SortKey<Column>) :
        ReMappedRecipe<Row, Column> {
        private val sortKeys: Array<out SortKey<Column>>
        override fun buildRowIndex(): UniqueIndex<Row> {
            return DefaultUniqueIndex<Row>(
                dataFrame.rowIndex,
                SortComparator<Row,Column,V>(dataFrame, *sortKeys)
            )
        }

        override fun buildColumnIndex(): UniqueIndex<Column> {
            return dataFrame.columnIndex
        }

        init {
            this.sortKeys = sortKeys
        }
    }

//    private inner class ColumnsReMappedRecipe(vararg columns: Column?) : ReMappedRecipe<Row?, Column?> {
//        private val columns: Array<Column?>?
//        fun buildRowIndex(): UniqueIndex<Row?>? {
//            return rowIndex
//        }
//
//        fun buildColumnIndex(): UniqueIndex<Column?>? {
//            return DefaultUniqueIndex.< Column > fromArray < Column ? > columns
//        }
//
//        init {
//            this.columns = columns
//        }
//    }

//    private inner class RemoveReMappedRecipe(vararg columns: Column?) : ReMappedRecipe<Row?, Column?> {
//        private val columns: Array<Column?>?
//        fun buildRowIndex(): UniqueIndex<Row?>? {
//            return rowIndex
//        }
//
//        fun buildColumnIndex(): UniqueIndex<Column?>? {
//            return columnIndex!!.difference(DefaultUniqueIndex(columns))
//        }
//
//        init {
//            this.columns = columns
//        }
//    }

//    private inner class RemoveDuplicatesReMappedRecipe(vararg columns: Column?) :
//        ReMappedRecipe<Row?, Column?> {
//        private val columns: Array<Column?>?
//        fun buildRowIndex(): UniqueIndex<Row?>? {
//            val rows: MutableList<Row?> = java.util.ArrayList<Row?>()
//            val unique: MutableSet<MultiKey?> = HashSet()
//            for (row in rows()!!) {
//                val values = arrayOfNulls<Any?>(columns!!.size)
//                var c = 0
//                for (column in columns) {
//                    values[c++] = getValueAt(row, column)
//                }
//                val key = MultiKey(*values)
//                if (!unique.contains(key)) {
//                    rows.add(row)
//                    unique.add(key)
//                }
//            }
//            return DefaultUniqueIndex.< Row > fromArray < Row ? > rows.toTypedArray()
//        }
//
//        fun buildColumnIndex(): UniqueIndex<Column?>? {
//            return columnIndex
//        }
//
//        init {
//            this.columns = columns
//        }
//    }

//    private inner class IntegerReIndexRecipe : ReIndexRecipe<Int?, Column?> {
//        fun buildRowIndex(): UniqueIndex<Int?>? {
//            return IntegerRangeUniqueIndex(0, rowCount - 1)
//        }
//
//        fun buildColumnIndex(): UniqueIndex<Column?>? {
//            return columnIndex
//        }
//    }

//    private inner class RowsDefaultReIndexRecipe(private val keepColumns: Boolean, vararg columns: Column?) :
//        ReIndexRecipe<MultiKey?, Column?> {
//        private val columns: Array<Column?>?
//        fun buildRowIndex(): UniqueIndex<MultiKey?>? {
//            var r = 0
//            val keys = arrayOfNulls<MultiKey?>(rowCount)
//            for (row in rows()!!) {
//                val values = arrayOfNulls<Any?>(columns!!.size)
//                var c = 0
//                for (column in columns) {
//                    values[c++] = getValueAt(row, column)
//                }
//                val key = MultiKey(*values)
//                keys[r++] = key
//            }
//            return DefaultUniqueIndex.< MultiKey > fromArray < MultiKey ? > keys
//        }
//
//        fun buildColumnIndex(): UniqueIndex<Column?>? {
//            return if (keepColumns) {
//                columnIndex
//            } else {
//                columnIndex!!.difference(DefaultUniqueIndex.< Column > fromArray < Column ? > columns)
//            }
//        }
