package org.molap.dataframe.rowmajor

import org.molap.dataframe.MutableDataFrame
import kotlin.reflect.KClass

interface RowMajorDataFrame<R, C, V> : MutableDataFrame<R, C, V> {
    fun addRow(row: R)
    fun replaceRow(oldRow: R, newRow: R)
    fun addRow(i: Int, row: R)
    fun addBeforeRow(insertionPoint: R, row: R)
    fun addAfterRow(insertionPoint: R, row: R)
    fun remove(row: R)
    fun retrieve(query: Query<R, C, V>): List<R>
    val queryBuilder: QueryBuilder<R, C, V>?

    interface Column<R, V> {
        val type: KClass<*>

        fun getValue(row: R): V
    }

    interface QueryBuilder<R, C, V> {
        fun equal(column: C, value: V): Query<R, C, V>?
        fun smallerThan(column: C, value: V): Query<R, C, V>?
        fun smallerThanOrEqualTo(column: C, value: V): Query<R, C, V>?
        fun greaterThan(column: C, value: V): Query<R, C, V>?
        fun greaterThanOrEqualTo(column: C, value: V): Query<R, C, V>?
        fun overlap(start1: C, end1: C, start2: V, end2: V): Query<R, C, V>?
        fun and(q1: Query<R, C, V>, q2: Query<R, C, V>): Query<R, C, V>?
        fun or(q1: Query<R, C, V>, q2: Query<R, C, V>): Query<R, C, V>?
    }

    interface Query<R, C, V> {
        fun matches(row: R): Boolean
        fun equal(column: C, value: V): Query<R, C, V>?
        fun smallerThan(column: C, value: V): Query<R, C, V>?
        fun smallerThanOrEqualTo(column: C, value: V): Query<R, C, V>?
        fun greaterThan(column: C, value: V): Query<R, C, V>?
        fun greaterThanOrEqualTo(column: C, value: V): Query<R, C, V>?
        fun and(query: Query<R, C, V>): Query<R, C, V>?
        fun or(query: Query<R, C, V>): Query<R, C, V>?
    }
}
