package org.molap.dataframe

fun <R> List<R>.toDataFrame(columns: Map<String,Column<R,Any?>>): DataFrame<R,String,Any?> {
    return ListDataFrame(this, columns)
}

inline fun <reified R> List<R>.toDataFrame(vararg columns: Pair<String,Column<R,Any?>>): DataFrame<R,String,Any?> {
    return toDataFrame(mapOf(*columns))
}

inline fun <reified R,C> List<R>.toDataFrame(block: ListDataFrameBuilder<R,C>.() -> Unit): DataFrame<R,C,Any?> {
    val builder = ListDataFrameBuilder<R,C>(this)
    builder.block()
    return builder.build()
}

inline fun <reified R,M,C> Map<R,M>.toDataFrame(block: MapDataFrameBuilder<R,M,C>.() -> Unit): DataFrame<R,C,Any?> {
    val builder = MapDataFrameBuilder<R,M,C>(this)
    builder.block()
    return builder.build()
}

