package org.molap.exporter

import org.molap.dataframe.DataFrame
import kotlin.reflect.KClass

interface DataFrameWriter {
    fun start()

    fun writeColumnName(name: String?, hasMore: Boolean)
    fun includeType(): Boolean

    fun writeType(name: KClass<*>, hasMore: Boolean)

    fun <R,C,V> writeCell(value: Any?, dataFrame: DataFrame<R,C,V>, rowKey: R, columnKey: C)

    fun nextColumn(hasMore: Boolean)

    fun nextRow()

    fun close()

//    fun setTimeZone(timeZone: TimeZone?)
}
