package org.molap.exporter

import org.molap.dataframe.DataFrame
import kotlin.reflect.KClass

class DelimitedDataFrameExport(private val writer: DataFrameWriter) : DataFrameExport {
    private var initialized = false

    private fun <R,C,V>  initialize(dataFrame: DataFrame<R,C,V> ) {
        writer.start()
        for (column in 0 until dataFrame.columnCount) {
            val value: String? = dataFrame.getColumnName(dataFrame.getColumnKey(column))
            writer.writeColumnName(value, column < dataFrame.columnCount - 1)
        }
        writer.nextRow()
        if (writer.includeType()) {
            for (column in 0 until dataFrame.columnCount) {
                val value: KClass<*> = dataFrame.getColumnClass(dataFrame.getColumnKey(column))
                writer.writeType(value, column < dataFrame.columnCount - 1)
            }
            writer.nextRow()
        }

    }

    override fun <R,C,V>  write(dataFrame: DataFrame<R,C,V> ) {
        if(!initialized) {
            initialize(dataFrame)

            initialized = true
        }

        for (row in 0 until dataFrame.rowCount) {
            for (column in 0 until dataFrame.columnCount) {
                try {
                    var value: V
                    val rowKey: R = dataFrame.getRowKey(row)
                    val columnKey: C = dataFrame.getColumnKey(column)
                    value = dataFrame.getValueAt(rowKey, columnKey)
                    writer.writeCell(value, dataFrame, rowKey, columnKey)
                } catch (e: Exception) {
                    e.printStackTrace()
                } finally {
                    writer.nextColumn(column < dataFrame.columnCount - 1)
                }
            }
            writer.nextRow()
        }
    }

    override fun close() {
        writer.close()
    }
}