package org.molap.index

class MultiKey(vararg values: Any) : Comparable<Any?> {
    private val array: Array<out Any>
    operator fun get(i: Int): Any {
        return array[i]
    }

    val size: Int
        get() = array.size

    override fun equals(o: Any?): Boolean {
        if (this === o) return true
        if (o == null || this::class != o::class) return false
        val multiKey = o as MultiKey

        // Probably incorrect - comparing Object[] arrays with Arrays.equals
        return array.equals(multiKey.array)
    }

    override fun hashCode(): Int {
        return array.hashCode()
    }

    override fun compareTo(other: Any?): Int {
        return if (other is MultiKey) {
            val a = this
            val a2 = other
            if (a === a2) return 0
            if (a == null || a2 == null) return -1
            val length = a.array.size
            if (a2.array.size != length) return 1
            for (i in 0 until length) {
                val o1 = a.array[i] as Comparable<Any>
                val o2 = a2.array[i] as Comparable<Any>
                if (!(o1 == null || o2 == null)) {
                    val c = o1.compareTo(o2)
                    if (c != 0) {
                        return c
                    }
                }
            }
            0
        } else {
            -1
        }
    }

    override fun toString(): String {
        return array.toString()
    }

    init {
        array = values
    }
}
