package org.molap.network

import com.macrofocus.common.selection.SingleSelection

interface WeightedNetwork<Node,Link,Value> : Network<Node, Link> {
    fun getDirectedSelection(): SingleSelection<Boolean>

    fun getDirectedLinks(from : Node) : Iterable<Link>

    fun getReverse(edge: Link): Link

    fun getWeight(link: Link) : Value

    fun addNetworkListener(listener: NetworkListener)

    fun removeNetworkListener(listener: NetworkListener)
}