package org.molap.network

import org.molap.dataframe.DataFrame

fun <Node,Link> Network<Node,Link>.findComponents(): List<Pair<Set<Node>, Set<Link>>> {
//    val adjacencyList = network.toAdjacencyList()
    val visited = mutableSetOf<Node>()
    val components = mutableListOf<Pair<Set<Node>, Set<Link>>>()

    fun dfs(node: Node, nodesInComponent: MutableSet<Node>, branchesInComponent: MutableSet<Link>) {
        if (node in visited) return
        visited.add(node)
        nodesInComponent.add(node)
        for (link in this.getLinks(node)) {
            branchesInComponent.add(link)
            val neighbor = this.getTo(link)
            dfs(neighbor, nodesInComponent, branchesInComponent)
        }
    }

    for (node in this.nodes) {
        if (node !in visited) {
            val nodesInComponent = mutableSetOf<Node>()
            val branchesInComponent = mutableSetOf<Link>()
            dfs(node, nodesInComponent, branchesInComponent)
            components.add(Pair(nodesInComponent, branchesInComponent))
        }
    }

    return components
}

fun <Node,Link,R,C,V> DataFrame<R, C, V>.findComponents(from: (R) -> Node, to: (R) -> Node, link: (R) -> Link): List<Pair<Set<Node>, Set<Link>>> {
    fun toAdjacencyList(): Map<Node, List<Pair<Node, Link>>> {
        val adjacencyList = mutableMapOf<Node, MutableList<Pair<Node, Link>>>()
        for (edge in this.rows()) {
            val from = from(edge)
            val to = to(edge)
            val link = link(edge)
            adjacencyList.getOrPut(from) { mutableListOf() }.add(Pair(to, link))
            adjacencyList.getOrPut(to) { mutableListOf() }.add(Pair(from, link))
        }
        return adjacencyList
    }

    val adjacencyList = toAdjacencyList()
    val visited = mutableSetOf<Node>()
    val components = mutableListOf<Pair<Set<Node>, Set<Link>>>()

    fun dfs(node: Node, nodesInComponent: MutableSet<Node>, branchesInComponent: MutableSet<Link>) {
        if (node in visited) return
        visited.add(node)
        nodesInComponent.add(node)
        for ((neighbor, link) in adjacencyList[node] ?: emptyList()) {
            branchesInComponent.add(link)
            dfs(neighbor, nodesInComponent, branchesInComponent)
        }
    }

    for (node in adjacencyList.keys) {
        if (node !in visited) {
            val nodesInComponent = mutableSetOf<Node>()
            val branchesInComponent = mutableSetOf<Link>()
            dfs(node, nodesInComponent, branchesInComponent)
            components.add(Pair(nodesInComponent, branchesInComponent))
        }
    }

    return components
}

fun <Node,Link,R> List<R>.findComponents(from: (R) -> Node, to: (R) -> Node, link: (R) -> Link): List<Pair<Set<Node>, Set<Link>>> {
    fun toAdjacencyList(): Map<Node, List<Pair<Node, Link>>> {
        val adjacencyList = mutableMapOf<Node, MutableList<Pair<Node, Link>>>()
        for (edge in this) {
            val from = from(edge)
            val to = to(edge)
            val link = link(edge)
            adjacencyList.getOrPut(from) { mutableListOf() }.add(Pair(to, link))
            adjacencyList.getOrPut(to) { mutableListOf() }.add(Pair(from, link))
        }
        return adjacencyList
    }

    val adjacencyList = toAdjacencyList()
    val visited = mutableSetOf<Node>()
    val components = mutableListOf<Pair<Set<Node>, Set<Link>>>()

    fun dfs(node: Node, nodesInComponent: MutableSet<Node>, branchesInComponent: MutableSet<Link>) {
        if (node in visited) return
        visited.add(node)
        nodesInComponent.add(node)
        for ((neighbor, link) in adjacencyList[node] ?: emptyList()) {
            branchesInComponent.add(link)
            dfs(neighbor, nodesInComponent, branchesInComponent)
        }
    }

    for (node in adjacencyList.keys) {
        if (node !in visited) {
            val nodesInComponent = mutableSetOf<Node>()
            val branchesInComponent = mutableSetOf<Link>()
            dfs(node, nodesInComponent, branchesInComponent)
            components.add(Pair(nodesInComponent, branchesInComponent))
        }
    }

    return components
}
