package org.molap.series

interface TimeSeries<K, V> : Series<K, V> {
    enum class TimeMode {
        Absolute, Relative, Sequential
    }

    fun getTime(mode: TimeMode, key: K): Long

    fun getAbsoluteTime(key: K): Long

    fun getRelativeTime(key: K): Long

    fun getSequantialTime(key: K): Long

    val minTime: Long

    val maxTime: Long
}