/*
 * Copyright (c) 2015 Macrofocus GmbH. All Rights Reserved.
 */
package org.molap.subset

import com.macrofocus.common.annotation.Synchronized
import com.macrofocus.common.collection.TIntArrayList
import com.macrofocus.common.collection.TIntList
import org.molap.series.Series

class DefaultOrdinalDimension<Row, Column, Value>(
    dataFrame: SubsetDataFrame<Row, Column, Value>,
    column: Column,
    filteringCallback: FilteringCallback<Row>
) : AbstractDimension<Row>(), OrdinalDimension<Row, Column, Value> {
    private val dataFrame: SubsetDataFrame<Row, Column, Value>
    private val column: Column
    private val filteringCallback: FilteringCallback<Row>
    override var activeIndices: IntArray? =null
    override var from: Value? = null
        private set
    override var to: Value? = null
        private set
    override val name: String?
        get() = column.toString()
    override val isReducable: Boolean
        get() = false

    override fun reduce(otherActiveIndices: IntArray?) {}
    override fun markDirty() {}
    override fun materializeIndex() {}
    override fun filterRange(from: Value, to: Value) {
        this.from = from
        this.to = to
        scheduleUpdateFilter()
    }

    override val isActive: Boolean
        get() = from == null && to == null

    override fun filterAll() {
        from = null
        to = null
        scheduleUpdateFilter()
    }

    override fun getValue(row: Row): Value {
        return dataFrame.getValueAt(row, column)
    }

    @Synchronized
    protected override fun updateFilter() {
        val oldIndices = activeIndices
        val newIndices = updateActiveIndices()

//        if((filtered != null && filtered.length > 0) || (unfiltered != null && unfiltered.length > 0)) {
        filteringCallback.filteringChanged(FilteringEvent<Row>(this, IndicesIterable(dataFrame.unfilteredDataFrame, object : IndicesSupplier {
            override fun get(): IntArray? {
                return dataFrame.computeFiltered(oldIndices, newIndices)
            }
        }), IndicesIterable(dataFrame.unfilteredDataFrame, object : IndicesSupplier {
            override fun get(): IntArray? {
                return dataFrame.computeUnfiltered(oldIndices, newIndices)
            }
        })))
        //        }
    }

    fun updateActiveIndices(): IntArray? {
        if (from != null && to != null) {
            val series: Series<Row, Value> = dataFrame.unfilteredDataFrame.getColumn(column)!!
            val list: TIntList = TIntArrayList()
            for (key in series.keys()!!) {
                val index = series.getAddress(key)
                val value: Value? = series[key]
                if (value != null) {
                    if (value is Number) {
                        val number = value as Number
                        val dValue = number.toDouble()
                        val dFrom = (from as Number).toDouble()
                        val dTo = (to as Number).toDouble()
                        if (dFrom <= dTo) {
                            if (dValue >= dFrom && dValue <= dTo) {
                                list.add(index)
                            }
                        } else {
                            if (dValue > dFrom || dValue < dTo) {
                                list.add(index)
                            }
                        }
//                    } else if (value is java.util.Date) {
//                        val date: java.util.Date = value as java.util.Date
//                        if (from is java.util.Date && to is java.util.Date) {
//                            val dFrom: java.util.Date = from as java.util.Date
//                            val dTo: java.util.Date = to as java.util.Date
//                            if (dTo.after(dFrom)) {
//                                if (date.compareTo(dFrom) >= 0 && date.compareTo(dTo) <= 0) {
//                                    list.add(index)
//                                }
//                            } else {
//                                if (date.compareTo(dFrom) > 0 || date.compareTo(dTo) < 0) {
//                                    list.add(index)
//                                }
//                            }
//                        } else if (from is Number && to is Number) {
//                            val dFrom = (from as Number).toDouble()
//                            val dTo = (to as Number).toDouble()
//                            if (dFrom <= dTo) {
//                                if (java.lang.Double.compare(date.getTime().toDouble(), dFrom) >= 0 && java.lang.Double.compare(
//                                        date.getTime().toDouble(),
//                                        dTo
//                                    ) <= 0
//                                ) {
//                                    list.add(index)
//                                }
//                            } else {
//                                if (Double.compare(date.getTime().toDouble(), dFrom) > 0 || java.lang.Double.compare(
//                                        date.getTime().toDouble(),
//                                        dTo
//                                    ) < 0
//                                ) {
//                                    list.add(index)
//                                }
//                            }
//                        }
                    } else if (value is Comparable<*>) {
                        try {
                            val dValue: Comparable<Value> = value as Comparable<Value>
                            val dFrom = from as Comparable<Value>
                            val dTo = to as Comparable<Value>
                            if (dFrom.compareTo(to!!) <= 0) {
                                if (dValue.compareTo(from!!) >= 0 && dValue.compareTo(to!!) <= 0) {
                                    list.add(index)
                                }
                            } else {
                                if (dValue.compareTo(from!!) > 0 || dValue.compareTo(to!!) < 0) {
                                    list.add(index)
                                }
                            }
                        } catch (e: Exception) {
                            e.printStackTrace()
                        }
                    }
                }
            }
            activeIndices = list.toIntArray()
        } else {
            activeIndices = null
        }
        return activeIndices
    }

    init {
        this.dataFrame = dataFrame
        this.column = column
        this.filteringCallback = filteringCallback
        updateActiveIndices()
    }
}