@file:OptIn(ExperimentalTime::class)

package com.macrofocus.plot.guide

import kotlin.time.Instant
import kotlin.js.Date
import kotlin.time.ExperimentalTime

actual class CPCalendar {
    private var date: Date

    init {
        this.date = Date()
    }

    actual fun get(field: Int): Int {
        when (field) {
            YEAR -> return date.getFullYear()
            MONTH -> return date.getMonth()
            DATE -> return date.getDate()
            HOUR_OF_DAY -> return date.getHours()
            MINUTE -> return date.getMinutes()
            SECOND -> return date.getSeconds()
            MILLISECOND -> return date.getMilliseconds()
        }
        throw UnsupportedOperationException()
    }

    actual fun setAll(years: Int, months: Int, days: Int, hours: Int, minutes: Int, seconds: Int) {
        set(YEAR, years)
        set(MONTH, months)
        set(DATE, days)
        set(HOUR_OF_DAY, hours)
        set(MINUTE, minutes)
        set(SECOND, seconds)
    }

    actual var time: Instant?
        get() = Instant.fromEpochMilliseconds(date.getTime() as Long)
        set(date) {
            this.date = Date(time!!.toEpochMilliseconds())
        }

    actual fun set(field: Int, i: Int) {
        when (field) {
            YEAR -> date.asDynamic().setFullYear(i)
            MONTH -> date.asDynamic().setMonth(i)
            DATE -> date.asDynamic().setDate(i)
            HOUR_OF_DAY -> date.asDynamic().setHours(i)
            MINUTE -> date.asDynamic().setMinutes(i)
            SECOND -> date.asDynamic().setSeconds(i)
            MILLISECOND -> date.asDynamic().setMilliseconds(i)
        }
    }

    actual fun clear(field: Int) {
        when (field) {
            YEAR -> date.asDynamic().setFullYear(0)
            MONTH -> date.asDynamic().setMonth(0)
            DATE -> date.asDynamic().setDate(0)
            HOUR_OF_DAY -> date.asDynamic().setHours(0)
            MINUTE -> date.asDynamic().setMinutes(0)
            SECOND -> date.asDynamic().setSeconds(0)
            MILLISECOND -> date.asDynamic().setMilliseconds(0)
        }
    }

    actual fun add(field: Int, multiple: Int) {
        when (field) {
            YEAR -> date.asDynamic().setFullYear(date.getFullYear() + multiple)
            MONTH -> date.asDynamic().setMonth(date.getMonth() + multiple)
            DATE -> date.asDynamic().setDate(date.getDate() + multiple)
            HOUR_OF_DAY -> date.asDynamic().setHours(date.getHours() + multiple)
            MINUTE -> date.asDynamic().setMinutes(date.getMinutes() + multiple)
            SECOND -> date.asDynamic().setSeconds(date.getSeconds() + multiple)
            MILLISECOND -> date.asDynamic().setMilliseconds(date.getMilliseconds() + multiple)
        }
    }

    actual companion object {
        /**
         * Field number for `get` and `set` indicating the
         * year. This is a calendar-specific value; see subclass documentation.
         */
        actual const val YEAR: Int = 1

        /**
         * Field number for `get` and `set` indicating the
         * month. This is a calendar-specific value. The first month of
         * the year in the Gregorian and Julian calendars is
         * `JANUARY` which is 0; the last depends on the number
         * of months in a year.
         */
        actual const val MONTH: Int = 2

        /**
         * Field number for `get` and `set` indicating the
         * day of the month. This is a synonym for `DAY_OF_MONTH`.
         * The first day of the month has value 1.
         */
        actual const val DATE: Int = 5

        /**
         * Field number for `get` and `set` indicating the
         * hour of the day. `HOUR_OF_DAY` is used for the 24-hour clock.
         * E.g., at 10:04:15.250 PM the `HOUR_OF_DAY` is 22.
         */
        actual const val HOUR_OF_DAY: Int = 11

        /**
         * Field number for `get` and `set` indicating the
         * minute within the hour.
         * E.g., at 10:04:15.250 PM the `MINUTE` is 4.
         */
        actual const val MINUTE: Int = 12

        /**
         * Field number for `get` and `set` indicating the
         * second within the minute.
         * E.g., at 10:04:15.250 PM the `SECOND` is 15.
         */
        actual const val SECOND: Int = 13

        /**
         * Field number for `get` and `set` indicating the
         * millisecond within the second.
         * E.g., at 10:04:15.250 PM the `MILLISECOND` is 250.
         */
        actual const val MILLISECOND: Int = 14

        /**
         * Value of the [.MONTH] field indicating the
         * first month of the year in the Gregorian and Julian calendars.
         */
        actual const val JANUARY: Int = 0

        /**
         * Value of the [.MONTH] field indicating the
         * second month of the year in the Gregorian and Julian calendars.
         */
        actual const val FEBRUARY: Int = 1

        /**
         * Value of the [.MONTH] field indicating the
         * third month of the year in the Gregorian and Julian calendars.
         */
        actual const val MARCH: Int = 2

        /**
         * Value of the [.MONTH] field indicating the
         * fourth month of the year in the Gregorian and Julian calendars.
         */
        actual const val APRIL: Int = 3

        /**
         * Value of the [.MONTH] field indicating the
         * fifth month of the year in the Gregorian and Julian calendars.
         */
        actual const val MAY: Int = 4

        /**
         * Value of the [.MONTH] field indicating the
         * sixth month of the year in the Gregorian and Julian calendars.
         */
        actual const val JUNE: Int = 5

        /**
         * Value of the [.MONTH] field indicating the
         * seventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val JULY: Int = 6

        /**
         * Value of the [.MONTH] field indicating the
         * eighth month of the year in the Gregorian and Julian calendars.
         */
        actual const val AUGUST: Int = 7

        /**
         * Value of the [.MONTH] field indicating the
         * ninth month of the year in the Gregorian and Julian calendars.
         */
        actual const val SEPTEMBER: Int = 8

        /**
         * Value of the [.MONTH] field indicating the
         * tenth month of the year in the Gregorian and Julian calendars.
         */
        actual const val OCTOBER: Int = 9

        /**
         * Value of the [.MONTH] field indicating the
         * eleventh month of the year in the Gregorian and Julian calendars.
         */
        actual const val NOVEMBER: Int = 10

        /**
         * Value of the [.MONTH] field indicating the
         * twelfth month of the year in the Gregorian and Julian calendars.
         */
        actual const val DECEMBER: Int = 11
    }
}