package org.molap.json

import org.molap.dataframe.DataFrame
import org.molap.dataframe.JsonDataFrame

fun DataFrame.Companion.readJson(json: String): DataFrame<Int, String, Any?> {
    return JsonDataFrame(json)
}

fun DataFrame.Companion.readJson(json: Any?): DataFrame<Int, String, Any?> {
    if(json is String) {
        return JsonDataFrame(json)
    } else if(json is Array<*>) {
        return JsonDataFrame(json as Array<Any?>)
    } else {
        return JsonDataFrame((json.asDynamic().data as Array<Any?>))
    }
}
